Public Class SAOpenArchInterfaceForm
    Inherits System.Windows.Forms.Form
    Dim nPts, nCloudPts As Integer
#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call
        SetControls(False)
        nPts = 0
        nCloudPts = 0
        UpdateBufferCountLabels()

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents AxSAOpenInst1 As AxSAOpenInstLib.AxSAOpenInst
    Friend WithEvents SendPtToSA As System.Windows.Forms.Button
    Friend WithEvents PtCollection As System.Windows.Forms.TextBox
    Friend WithEvents Label1 As System.Windows.Forms.Label
    Friend WithEvents Label2 As System.Windows.Forms.Label
    Friend WithEvents PtGroup As System.Windows.Forms.TextBox
    Friend WithEvents Label3 As System.Windows.Forms.Label
    Friend WithEvents PtName As System.Windows.Forms.TextBox
    Friend WithEvents Label4 As System.Windows.Forms.Label
    Friend WithEvents ptX As System.Windows.Forms.TextBox
    Friend WithEvents Label5 As System.Windows.Forms.Label
    Friend WithEvents ptY As System.Windows.Forms.TextBox
    Friend WithEvents Label6 As System.Windows.Forms.Label
    Friend WithEvents ptZ As System.Windows.Forms.TextBox
    Friend WithEvents Logon As System.Windows.Forms.Button
    Friend WithEvents Label7 As System.Windows.Forms.Label
    Friend WithEvents ptZu As System.Windows.Forms.TextBox
    Friend WithEvents Label8 As System.Windows.Forms.Label
    Friend WithEvents ptYu As System.Windows.Forms.TextBox
    Friend WithEvents Label9 As System.Windows.Forms.Label
    Friend WithEvents ptXu As System.Windows.Forms.TextBox
    Friend WithEvents Label10 As System.Windows.Forms.Label
    Friend WithEvents ptOffset As System.Windows.Forms.TextBox
    Friend WithEvents GroupBox1 As System.Windows.Forms.GroupBox
    Friend WithEvents Label11 As System.Windows.Forms.Label
    Friend WithEvents cdZ As System.Windows.Forms.TextBox
    Friend WithEvents Label12 As System.Windows.Forms.Label
    Friend WithEvents cdY As System.Windows.Forms.TextBox
    Friend WithEvents Label13 As System.Windows.Forms.Label
    Friend WithEvents cdX As System.Windows.Forms.TextBox
    Friend WithEvents Label14 As System.Windows.Forms.Label
    Friend WithEvents CdName As System.Windows.Forms.TextBox
    Friend WithEvents Label15 As System.Windows.Forms.Label
    Friend WithEvents CdCollection As System.Windows.Forms.TextBox
    Friend WithEvents SendCdPts As System.Windows.Forms.Button
    Friend WithEvents CloseButton As System.Windows.Forms.Button
    Friend WithEvents PostMeasToSA As System.Windows.Forms.Button
    Friend WithEvents PostCdPtToSA As System.Windows.Forms.Button
    Friend WithEvents NumBufferPts As System.Windows.Forms.Label
    Friend WithEvents Label16 As System.Windows.Forms.Label
    Friend WithEvents ClearPtBuffer As System.Windows.Forms.Button
    Friend WithEvents ClearCldPtBuffer As System.Windows.Forms.Button
    Friend WithEvents Label17 As System.Windows.Forms.Label
    Friend WithEvents NumBufferCldPts As System.Windows.Forms.Label
    Friend WithEvents GroupBox2 As System.Windows.Forms.GroupBox
    Friend WithEvents MakeRandAddToBuffer As System.Windows.Forms.Button
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Dim resources As System.Resources.ResourceManager = New System.Resources.ResourceManager(GetType(SAOpenArchInterfaceForm))
        Me.AxSAOpenInst1 = New AxSAOpenInstLib.AxSAOpenInst
        Me.Logon = New System.Windows.Forms.Button
        Me.SendPtToSA = New System.Windows.Forms.Button
        Me.PtCollection = New System.Windows.Forms.TextBox
        Me.Label1 = New System.Windows.Forms.Label
        Me.Label2 = New System.Windows.Forms.Label
        Me.PtGroup = New System.Windows.Forms.TextBox
        Me.Label3 = New System.Windows.Forms.Label
        Me.PtName = New System.Windows.Forms.TextBox
        Me.Label4 = New System.Windows.Forms.Label
        Me.ptX = New System.Windows.Forms.TextBox
        Me.Label5 = New System.Windows.Forms.Label
        Me.ptY = New System.Windows.Forms.TextBox
        Me.Label6 = New System.Windows.Forms.Label
        Me.ptZ = New System.Windows.Forms.TextBox
        Me.Label7 = New System.Windows.Forms.Label
        Me.ptZu = New System.Windows.Forms.TextBox
        Me.Label8 = New System.Windows.Forms.Label
        Me.ptYu = New System.Windows.Forms.TextBox
        Me.Label9 = New System.Windows.Forms.Label
        Me.ptXu = New System.Windows.Forms.TextBox
        Me.Label10 = New System.Windows.Forms.Label
        Me.ptOffset = New System.Windows.Forms.TextBox
        Me.ClearPtBuffer = New System.Windows.Forms.Button
        Me.GroupBox1 = New System.Windows.Forms.GroupBox
        Me.Label16 = New System.Windows.Forms.Label
        Me.NumBufferPts = New System.Windows.Forms.Label
        Me.PostMeasToSA = New System.Windows.Forms.Button
        Me.Label11 = New System.Windows.Forms.Label
        Me.cdZ = New System.Windows.Forms.TextBox
        Me.Label12 = New System.Windows.Forms.Label
        Me.cdY = New System.Windows.Forms.TextBox
        Me.Label13 = New System.Windows.Forms.Label
        Me.cdX = New System.Windows.Forms.TextBox
        Me.Label14 = New System.Windows.Forms.Label
        Me.CdName = New System.Windows.Forms.TextBox
        Me.Label15 = New System.Windows.Forms.Label
        Me.CdCollection = New System.Windows.Forms.TextBox
        Me.SendCdPts = New System.Windows.Forms.Button
        Me.CloseButton = New System.Windows.Forms.Button
        Me.PostCdPtToSA = New System.Windows.Forms.Button
        Me.ClearCldPtBuffer = New System.Windows.Forms.Button
        Me.Label17 = New System.Windows.Forms.Label
        Me.NumBufferCldPts = New System.Windows.Forms.Label
        Me.MakeRandAddToBuffer = New System.Windows.Forms.Button
        Me.GroupBox2 = New System.Windows.Forms.GroupBox
        CType(Me.AxSAOpenInst1, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.GroupBox1.SuspendLayout()
        Me.SuspendLayout()
        '
        'AxSAOpenInst1
        '
        Me.AxSAOpenInst1.Enabled = True
        Me.AxSAOpenInst1.Location = New System.Drawing.Point(8, 8)
        Me.AxSAOpenInst1.Name = "AxSAOpenInst1"
        Me.AxSAOpenInst1.OcxState = CType(resources.GetObject("AxSAOpenInst1.OcxState"), System.Windows.Forms.AxHost.State)
        Me.AxSAOpenInst1.Size = New System.Drawing.Size(100, 50)
        Me.AxSAOpenInst1.TabIndex = 0
        '
        'Logon
        '
        Me.Logon.Location = New System.Drawing.Point(128, 24)
        Me.Logon.Name = "Logon"
        Me.Logon.Size = New System.Drawing.Size(144, 24)
        Me.Logon.TabIndex = 1
        Me.Logon.Text = "Logon ... Connect to SA"
        '
        'SendPtToSA
        '
        Me.SendPtToSA.Location = New System.Drawing.Point(392, 144)
        Me.SendPtToSA.Name = "SendPtToSA"
        Me.SendPtToSA.Size = New System.Drawing.Size(88, 48)
        Me.SendPtToSA.TabIndex = 2
        Me.SendPtToSA.Text = "(2) Send Measurements to SA"
        '
        'PtCollection
        '
        Me.PtCollection.Location = New System.Drawing.Point(120, 96)
        Me.PtCollection.Name = "PtCollection"
        Me.PtCollection.TabIndex = 3
        Me.PtCollection.Text = ""
        '
        'Label1
        '
        Me.Label1.Location = New System.Drawing.Point(48, 96)
        Me.Label1.Name = "Label1"
        Me.Label1.Size = New System.Drawing.Size(64, 23)
        Me.Label1.TabIndex = 4
        Me.Label1.Text = "Collection:"
        Me.Label1.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'Label2
        '
        Me.Label2.Location = New System.Drawing.Point(64, 128)
        Me.Label2.Name = "Label2"
        Me.Label2.Size = New System.Drawing.Size(48, 23)
        Me.Label2.TabIndex = 6
        Me.Label2.Text = "Group:"
        Me.Label2.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'PtGroup
        '
        Me.PtGroup.Location = New System.Drawing.Point(120, 128)
        Me.PtGroup.Name = "PtGroup"
        Me.PtGroup.TabIndex = 5
        Me.PtGroup.Text = ""
        '
        'Label3
        '
        Me.Label3.Location = New System.Drawing.Point(16, 160)
        Me.Label3.Name = "Label3"
        Me.Label3.Size = New System.Drawing.Size(96, 23)
        Me.Label3.TabIndex = 8
        Me.Label3.Text = "Base Pt Name:"
        Me.Label3.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'PtName
        '
        Me.PtName.Location = New System.Drawing.Point(120, 160)
        Me.PtName.Name = "PtName"
        Me.PtName.TabIndex = 7
        Me.PtName.Text = ""
        '
        'Label4
        '
        Me.Label4.Location = New System.Drawing.Point(88, 200)
        Me.Label4.Name = "Label4"
        Me.Label4.Size = New System.Drawing.Size(16, 23)
        Me.Label4.TabIndex = 10
        Me.Label4.Text = "X:"
        Me.Label4.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'ptX
        '
        Me.ptX.ImeMode = System.Windows.Forms.ImeMode.NoControl
        Me.ptX.Location = New System.Drawing.Point(120, 200)
        Me.ptX.Name = "ptX"
        Me.ptX.TabIndex = 9
        Me.ptX.Text = "0.0"
        '
        'Label5
        '
        Me.Label5.Location = New System.Drawing.Point(80, 228)
        Me.Label5.Name = "Label5"
        Me.Label5.Size = New System.Drawing.Size(24, 23)
        Me.Label5.TabIndex = 12
        Me.Label5.Text = "Y:"
        Me.Label5.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'ptY
        '
        Me.ptY.Location = New System.Drawing.Point(120, 228)
        Me.ptY.Name = "ptY"
        Me.ptY.TabIndex = 11
        Me.ptY.Text = "0.0"
        '
        'Label6
        '
        Me.Label6.Location = New System.Drawing.Point(88, 256)
        Me.Label6.Name = "Label6"
        Me.Label6.Size = New System.Drawing.Size(16, 23)
        Me.Label6.TabIndex = 14
        Me.Label6.Text = "Z:"
        Me.Label6.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'ptZ
        '
        Me.ptZ.Location = New System.Drawing.Point(120, 256)
        Me.ptZ.Name = "ptZ"
        Me.ptZ.TabIndex = 13
        Me.ptZ.Text = "0.0"
        '
        'Label7
        '
        Me.Label7.Location = New System.Drawing.Point(224, 256)
        Me.Label7.Name = "Label7"
        Me.Label7.Size = New System.Drawing.Size(24, 23)
        Me.Label7.TabIndex = 20
        Me.Label7.Text = "uZ:"
        Me.Label7.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'ptZu
        '
        Me.ptZu.Location = New System.Drawing.Point(264, 256)
        Me.ptZu.Name = "ptZu"
        Me.ptZu.TabIndex = 19
        Me.ptZu.Text = "0.0"
        '
        'Label8
        '
        Me.Label8.Location = New System.Drawing.Point(224, 228)
        Me.Label8.Name = "Label8"
        Me.Label8.Size = New System.Drawing.Size(24, 23)
        Me.Label8.TabIndex = 18
        Me.Label8.Text = "uY:"
        Me.Label8.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'ptYu
        '
        Me.ptYu.Location = New System.Drawing.Point(264, 228)
        Me.ptYu.Name = "ptYu"
        Me.ptYu.TabIndex = 17
        Me.ptYu.Text = "0.0"
        '
        'Label9
        '
        Me.Label9.Location = New System.Drawing.Point(224, 200)
        Me.Label9.Name = "Label9"
        Me.Label9.Size = New System.Drawing.Size(24, 23)
        Me.Label9.TabIndex = 16
        Me.Label9.Text = "uX:"
        Me.Label9.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'ptXu
        '
        Me.ptXu.Location = New System.Drawing.Point(264, 200)
        Me.ptXu.Name = "ptXu"
        Me.ptXu.TabIndex = 15
        Me.ptXu.Text = "0.0"
        '
        'Label10
        '
        Me.Label10.Location = New System.Drawing.Point(144, 288)
        Me.Label10.Name = "Label10"
        Me.Label10.Size = New System.Drawing.Size(56, 23)
        Me.Label10.TabIndex = 22
        Me.Label10.Text = "Offset:"
        Me.Label10.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'ptOffset
        '
        Me.ptOffset.Location = New System.Drawing.Point(216, 288)
        Me.ptOffset.Name = "ptOffset"
        Me.ptOffset.TabIndex = 21
        Me.ptOffset.Text = "0.0"
        '
        'ClearPtBuffer
        '
        Me.ClearPtBuffer.Location = New System.Drawing.Point(248, 40)
        Me.ClearPtBuffer.Name = "ClearPtBuffer"
        Me.ClearPtBuffer.Size = New System.Drawing.Size(104, 24)
        Me.ClearPtBuffer.TabIndex = 23
        Me.ClearPtBuffer.Text = "Clear Pt Buffer"
        '
        'GroupBox1
        '
        Me.GroupBox1.Controls.Add(Me.Label16)
        Me.GroupBox1.Controls.Add(Me.NumBufferPts)
        Me.GroupBox1.Controls.Add(Me.PostMeasToSA)
        Me.GroupBox1.Controls.Add(Me.SendPtToSA)
        Me.GroupBox1.Controls.Add(Me.ClearPtBuffer)
        Me.GroupBox1.Location = New System.Drawing.Point(8, 80)
        Me.GroupBox1.Name = "GroupBox1"
        Me.GroupBox1.Size = New System.Drawing.Size(504, 240)
        Me.GroupBox1.TabIndex = 24
        Me.GroupBox1.TabStop = False
        Me.GroupBox1.Text = "Pt Data"
        '
        'Label16
        '
        Me.Label16.Location = New System.Drawing.Point(240, 16)
        Me.Label16.Name = "Label16"
        Me.Label16.Size = New System.Drawing.Size(128, 16)
        Me.Label16.TabIndex = 4
        Me.Label16.Tag = ""
        Me.Label16.Text = "Number of Pts in Buffer:"
        Me.Label16.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'NumBufferPts
        '
        Me.NumBufferPts.Location = New System.Drawing.Point(376, 16)
        Me.NumBufferPts.Name = "NumBufferPts"
        Me.NumBufferPts.TabIndex = 3
        '
        'PostMeasToSA
        '
        Me.PostMeasToSA.Location = New System.Drawing.Point(392, 88)
        Me.PostMeasToSA.Name = "PostMeasToSA"
        Me.PostMeasToSA.Size = New System.Drawing.Size(88, 48)
        Me.PostMeasToSA.TabIndex = 0
        Me.PostMeasToSA.Text = "(1) Post Meas to SA Buffer"
        '
        'Label11
        '
        Me.Label11.Location = New System.Drawing.Point(96, 456)
        Me.Label11.Name = "Label11"
        Me.Label11.Size = New System.Drawing.Size(16, 23)
        Me.Label11.TabIndex = 34
        Me.Label11.Text = "Z:"
        Me.Label11.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'cdZ
        '
        Me.cdZ.Location = New System.Drawing.Point(128, 456)
        Me.cdZ.Name = "cdZ"
        Me.cdZ.TabIndex = 33
        Me.cdZ.Text = "0.0"
        '
        'Label12
        '
        Me.Label12.Location = New System.Drawing.Point(88, 432)
        Me.Label12.Name = "Label12"
        Me.Label12.Size = New System.Drawing.Size(24, 23)
        Me.Label12.TabIndex = 32
        Me.Label12.Text = "Y:"
        Me.Label12.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'cdY
        '
        Me.cdY.Location = New System.Drawing.Point(128, 432)
        Me.cdY.Name = "cdY"
        Me.cdY.TabIndex = 31
        Me.cdY.Text = "0.0"
        '
        'Label13
        '
        Me.Label13.Location = New System.Drawing.Point(96, 408)
        Me.Label13.Name = "Label13"
        Me.Label13.Size = New System.Drawing.Size(16, 23)
        Me.Label13.TabIndex = 30
        Me.Label13.Text = "X:"
        Me.Label13.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'cdX
        '
        Me.cdX.Location = New System.Drawing.Point(128, 408)
        Me.cdX.Name = "cdX"
        Me.cdX.TabIndex = 29
        Me.cdX.Text = "0.0"
        '
        'Label14
        '
        Me.Label14.Location = New System.Drawing.Point(24, 376)
        Me.Label14.Name = "Label14"
        Me.Label14.Size = New System.Drawing.Size(72, 23)
        Me.Label14.TabIndex = 28
        Me.Label14.Text = "Cloud Name:"
        Me.Label14.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'CdName
        '
        Me.CdName.Location = New System.Drawing.Point(112, 376)
        Me.CdName.Name = "CdName"
        Me.CdName.TabIndex = 27
        Me.CdName.Text = ""
        '
        'Label15
        '
        Me.Label15.Location = New System.Drawing.Point(32, 344)
        Me.Label15.Name = "Label15"
        Me.Label15.Size = New System.Drawing.Size(64, 23)
        Me.Label15.TabIndex = 26
        Me.Label15.Text = "Collection:"
        Me.Label15.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'CdCollection
        '
        Me.CdCollection.Location = New System.Drawing.Point(112, 344)
        Me.CdCollection.Name = "CdCollection"
        Me.CdCollection.TabIndex = 25
        Me.CdCollection.Text = ""
        '
        'SendCdPts
        '
        Me.SendCdPts.Location = New System.Drawing.Point(400, 440)
        Me.SendCdPts.Name = "SendCdPts"
        Me.SendCdPts.Size = New System.Drawing.Size(88, 48)
        Me.SendCdPts.TabIndex = 35
        Me.SendCdPts.Text = "(2) Send Cloud Pt to SA"
        '
        'CloseButton
        '
        Me.CloseButton.Location = New System.Drawing.Point(256, 520)
        Me.CloseButton.Name = "CloseButton"
        Me.CloseButton.TabIndex = 36
        Me.CloseButton.Text = "Close"
        '
        'PostCdPtToSA
        '
        Me.PostCdPtToSA.Location = New System.Drawing.Point(400, 384)
        Me.PostCdPtToSA.Name = "PostCdPtToSA"
        Me.PostCdPtToSA.Size = New System.Drawing.Size(88, 48)
        Me.PostCdPtToSA.TabIndex = 37
        Me.PostCdPtToSA.Text = "(1) Post Cloud Pt to SA Buffer"
        '
        'ClearCldPtBuffer
        '
        Me.ClearCldPtBuffer.Location = New System.Drawing.Point(256, 384)
        Me.ClearCldPtBuffer.Name = "ClearCldPtBuffer"
        Me.ClearCldPtBuffer.Size = New System.Drawing.Size(120, 23)
        Me.ClearCldPtBuffer.TabIndex = 38
        Me.ClearCldPtBuffer.Text = "Clear Pt Cloud Buffer"
        '
        'Label17
        '
        Me.Label17.Location = New System.Drawing.Point(216, 344)
        Me.Label17.Name = "Label17"
        Me.Label17.Size = New System.Drawing.Size(160, 16)
        Me.Label17.TabIndex = 40
        Me.Label17.Tag = ""
        Me.Label17.Text = "Number of Cld Pts in Buffer:"
        Me.Label17.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'NumBufferCldPts
        '
        Me.NumBufferCldPts.Location = New System.Drawing.Point(384, 344)
        Me.NumBufferCldPts.Name = "NumBufferCldPts"
        Me.NumBufferCldPts.TabIndex = 39
        '
        'MakeRandAddToBuffer
        '
        Me.MakeRandAddToBuffer.Location = New System.Drawing.Point(264, 424)
        Me.MakeRandAddToBuffer.Name = "MakeRandAddToBuffer"
        Me.MakeRandAddToBuffer.Size = New System.Drawing.Size(88, 56)
        Me.MakeRandAddToBuffer.TabIndex = 41
        Me.MakeRandAddToBuffer.Text = "Make Random Cld and Post to SA Buffer"
        '
        'GroupBox2
        '
        Me.GroupBox2.Location = New System.Drawing.Point(8, 328)
        Me.GroupBox2.Name = "GroupBox2"
        Me.GroupBox2.Size = New System.Drawing.Size(504, 168)
        Me.GroupBox2.TabIndex = 42
        Me.GroupBox2.TabStop = False
        Me.GroupBox2.Text = "Point Cloud Data"
        '
        'SAOpenArchInterfaceForm
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(528, 550)
        Me.Controls.Add(Me.MakeRandAddToBuffer)
        Me.Controls.Add(Me.Label17)
        Me.Controls.Add(Me.NumBufferCldPts)
        Me.Controls.Add(Me.ClearCldPtBuffer)
        Me.Controls.Add(Me.PostCdPtToSA)
        Me.Controls.Add(Me.CloseButton)
        Me.Controls.Add(Me.SendCdPts)
        Me.Controls.Add(Me.Label11)
        Me.Controls.Add(Me.cdZ)
        Me.Controls.Add(Me.Label12)
        Me.Controls.Add(Me.cdY)
        Me.Controls.Add(Me.Label13)
        Me.Controls.Add(Me.cdX)
        Me.Controls.Add(Me.Label14)
        Me.Controls.Add(Me.CdName)
        Me.Controls.Add(Me.Label15)
        Me.Controls.Add(Me.CdCollection)
        Me.Controls.Add(Me.Label10)
        Me.Controls.Add(Me.ptOffset)
        Me.Controls.Add(Me.Label7)
        Me.Controls.Add(Me.ptZu)
        Me.Controls.Add(Me.Label8)
        Me.Controls.Add(Me.ptYu)
        Me.Controls.Add(Me.Label9)
        Me.Controls.Add(Me.ptXu)
        Me.Controls.Add(Me.Label6)
        Me.Controls.Add(Me.ptZ)
        Me.Controls.Add(Me.Label5)
        Me.Controls.Add(Me.ptY)
        Me.Controls.Add(Me.Label4)
        Me.Controls.Add(Me.ptX)
        Me.Controls.Add(Me.Label3)
        Me.Controls.Add(Me.PtName)
        Me.Controls.Add(Me.Label2)
        Me.Controls.Add(Me.PtGroup)
        Me.Controls.Add(Me.Label1)
        Me.Controls.Add(Me.PtCollection)
        Me.Controls.Add(Me.Logon)
        Me.Controls.Add(Me.AxSAOpenInst1)
        Me.Controls.Add(Me.GroupBox1)
        Me.Controls.Add(Me.GroupBox2)
        Me.Name = "SAOpenArchInterfaceForm"
        Me.Text = "SA Open Arch Interface"
        CType(Me.AxSAOpenInst1, System.ComponentModel.ISupportInitialize).EndInit()
        Me.GroupBox1.ResumeLayout(False)
        Me.ResumeLayout(False)

    End Sub

#End Region

    Private Sub AxSAOpenInst1_Enter(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles AxSAOpenInst1.Enter

    End Sub

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Logon.Click
        SetControls(AxSAOpenInst1.PopLogonDialog())

    End Sub

    Private Sub SendPtToSA_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SendPtToSA.Click
        Dim offset As Double
        GetValue(offset, ptOffset.Text)
        AxSAOpenInst1.SendMeasurements(PtCollection.Text, PtGroup.Text, PtName.Text, offset, offset)
        AxSAOpenInst1.ClearMeasurements()
        nPts = 0
        UpdateBufferCountLabels()

    End Sub
    Private Sub SendCdPt_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SendCdPts.Click

        AxSAOpenInst1.SendCloud(CdName.Text, CdCollection.Text)
        AxSAOpenInst1.ClearCloud()
        nCloudPts = 0
        UpdateBufferCountLabels()

    End Sub
    Private Sub SetControls(ByVal connectedToSA As Boolean)
        SendPtToSA.Enabled = connectedToSA
        PtCollection.Enabled = connectedToSA
        PtGroup.Enabled = connectedToSA
        PtName.Enabled = connectedToSA
        ptX.Enabled = connectedToSA
        ptY.Enabled = connectedToSA
        ptZ.Enabled = connectedToSA
        ptXu.Enabled = connectedToSA
        ptYu.Enabled = connectedToSA
        ptZu.Enabled = connectedToSA
        ptOffset.Enabled = connectedToSA
        ClearPtBuffer.Enabled = connectedToSA
        MakeRandAddToBuffer.Enabled = connectedToSA
        PostMeasToSA.Enabled = connectedToSA
        cdX.Enabled = connectedToSA
        cdY.Enabled = connectedToSA
        cdZ.Enabled = connectedToSA
        CdName.Enabled = connectedToSA
        CdCollection.Enabled = connectedToSA
        ClearCldPtBuffer.Enabled = connectedToSA
        PostCdPtToSA.Enabled = connectedToSA
        SendCdPts.Enabled = connectedToSA
        If connectedToSA = True Then
            Logon.Enabled = False
        Else
            Logon.Enabled = True

        End If
    End Sub
    Private Sub GetPointData(ByRef x As Double, ByRef y As Double, ByRef z As Double, ByRef xU As Double, ByRef yU As Double, ByRef zU As Double)
        GetValue(x, ptX.Text)
        GetValue(y, ptY.Text)
        GetValue(z, ptZ.Text)
        GetValue(xU, ptXu.Text)
        GetValue(yU, ptYu.Text)
        GetValue(zU, ptZu.Text)
    End Sub

    Private Sub GetCloudPointData(ByRef x As Double, ByRef y As Double, ByRef z As Double)
        GetValue(x, cdX.Text)
        GetValue(y, cdY.Text)
        GetValue(z, cdZ.Text)
    End Sub
    Private Sub GetValue(ByRef x As Double, ByRef s As String)
        Try
            x = System.Convert.ToDouble(s)
        Catch exception As System.FormatException
            x = 0.0
        End Try
    End Sub
    Private Sub ClearPtData_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ClearPtBuffer.Click
        nPts = 0
        UpdateBufferCountLabels()
        AxSAOpenInst1.ClearMeasurements()
        Update()
    End Sub
    Private Sub UpdateBufferCountLabels()
        NumBufferPts.Text = System.Convert.ToString(nPts)
        NumBufferCldPts.Text = System.Convert.ToString(nCloudPts)
        Update()
    End Sub

    Private Sub Button1_Click_1(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CloseButton.Click
        Close()
    End Sub

    Private Sub PostMeasToSA_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PostMeasToSA.Click
        Dim x, y, z, xU, yU, zU As Double
        GetPointData(x, y, z, xU, yU, zU)

        AxSAOpenInst1.AddMeasurement(x, y, z, xU, yU, zU)
        nPts = nPts + 1
        UpdateBufferCountLabels()

    End Sub

    Private Sub ClearCldPtBuffer_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ClearCldPtBuffer.Click
        nCloudPts = 0
        UpdateBufferCountLabels()
        AxSAOpenInst1.ClearCloud()
        Update()
    End Sub

    Private Sub PostCdPtToSA_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PostCdPtToSA.Click
        Dim x, y, z As Double
        GetCloudPointData(x, y, z)

        AxSAOpenInst1.AddCloudPoint(x, y, z)
        nCloudPts = nCloudPts + 1
        UpdateBufferCountLabels()

    End Sub

    Private Sub MakeRandAddToBuffer_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MakeRandAddToBuffer.Click
        'The number of points to be generated...
        Dim i As Integer = 0
        Dim num As Integer = 10000
        Dim xmin, ymin, zmin, xmax, ymax, zmax, x, y, z, xdiff, ydiff, zdiff As Double
        Dim r As New System.Random

        ' x / y / z ranges...
        xmin = -10.0
        ymin = -10.0
        zmin = -10.0
        xmax = 10.0
        ymax = 10.0
        zmax = 10.0

        For i = 1 To num
            ' Statements to operate with current values of x, y and z
            x = r.NextDouble ' Random double range is from 0.0 to 1.0
            y = r.NextDouble
            z = r.NextDouble
            xdiff = xmax - xmin
            ydiff = ymax - ymin
            zdiff = zmax - zmin
            xdiff *= x
            ydiff *= y
            zdiff *= z
            x = xmin + xdiff
            y = ymin + ydiff
            z = zmin + zdiff
            AxSAOpenInst1.AddCloudPoint(x, y, z)
            nCloudPts = nCloudPts + 1
        Next i
        UpdateBufferCountLabels()

    End Sub
End Class
